/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.netmusic.compat.tlm.inventory;

import com.github.tartaricacid.netmusic.compat.tlm.backpack.data.MusicPlayerBackpackData;
import com.github.tartaricacid.netmusic.compat.tlm.chatbubble.LyricChatBubbleData;
import com.github.tartaricacid.netmusic.compat.tlm.message.MaidMusicToClientMessage;
import com.github.tartaricacid.netmusic.compat.tlm.message.MaidStopMusicMessage;
import com.github.tartaricacid.netmusic.init.InitItems;
import com.github.tartaricacid.netmusic.item.ItemMusicCD;
import com.github.tartaricacid.netmusic.network.NetworkHandler;
import com.github.tartaricacid.touhoulittlemaid.entity.chatbubble.ChatBubbleDataCollection;
import com.github.tartaricacid.touhoulittlemaid.entity.chatbubble.IChatBubbleData;
import com.github.tartaricacid.touhoulittlemaid.inventory.container.MaidMainContainer;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.longs.LongBidirectionalIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.common.extensions.IMenuTypeExtension;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.SlotItemHandler;
import net.neoforged.neoforge.items.wrapper.CombinedInvWrapper;
import org.jetbrains.annotations.NotNull;

public class MusicPlayerBackpackContainer
extends MaidMainContainer {
    public static final MenuType<MusicPlayerBackpackContainer> TYPE = IMenuTypeExtension.create((windowId, inv, data) -> new MusicPlayerBackpackContainer(windowId, inv, data.readInt()));
    private static final ResourceLocation EMPTY_CD_SLOT = ResourceLocation.fromNamespaceAndPath((String)"netmusic", (String)"slot/music_cd_slot");
    private final ContainerData data;

    public MusicPlayerBackpackContainer(int id, Inventory inventory, int entityId) {
        super(TYPE, id, inventory, entityId);
        MusicPlayerBackpackData musicPlayerBackpackData = this.getMaid().getBackpackData() instanceof MusicPlayerBackpackData ? (MusicPlayerBackpackData)this.getMaid().getBackpackData() : new MusicPlayerBackpackData();
        this.data = musicPlayerBackpackData.getDataAccess();
        this.addDataSlots(this.data);
    }

    protected void addBackpackInv(Inventory inventory) {
        for (int y = 0; y < 4; ++y) {
            for (int x = 0; x < 6; ++x) {
                int index = (y + 1) * 6 + x;
                this.addSlot((Slot)new SlotItemHandler(this, (IItemHandler)this.maid.getMaidInv(), index, 143 + 18 * x, 57 + 18 * y){

                    public boolean mayPlace(@NotNull ItemStack stack) {
                        return stack.is((Item)InitItems.MUSIC_CD.get());
                    }

                    @OnlyIn(value=Dist.CLIENT)
                    public Pair<ResourceLocation, ResourceLocation> getNoItemIcon() {
                        return Pair.of((Object)InventoryMenu.BLOCK_ATLAS, (Object)EMPTY_CD_SLOT);
                    }
                });
            }
        }
    }

    public boolean clickMenuButton(Player player, int id) {
        if (id == 0) {
            return this.previousSlot();
        }
        if (id == 1) {
            return this.nextSlot();
        }
        if (id == 2) {
            return this.stopMusic();
        }
        if (id == 3) {
            this.stopMusic();
            return this.playMusic();
        }
        return false;
    }

    private boolean previousSlot() {
        this.stopMusic();
        int slotId = this.data.get(0);
        if (--slotId < 0) {
            slotId = 23;
        }
        this.data.set(0, slotId);
        return true;
    }

    private boolean nextSlot() {
        this.stopMusic();
        int slotId = this.data.get(0);
        if (++slotId > 23) {
            slotId = 0;
        }
        this.data.set(0, slotId);
        return true;
    }

    private boolean playMusic() {
        CombinedInvWrapper availableInv;
        ItemStack stackInSlot;
        if (this.maid == null) {
            return false;
        }
        int slotId = this.getSelectSlotId();
        if (0 <= slotId && slotId < 24 && (stackInSlot = (availableInv = this.maid.getAvailableInv(false)).getStackInSlot(6 + slotId)).is((Item)InitItems.MUSIC_CD.get())) {
            ItemMusicCD.SongInfo info = ItemMusicCD.getSongInfo(stackInSlot);
            if (info == null) {
                return false;
            }
            this.setSoundTicks(info.songTime * 20 + 64);
            MaidMusicToClientMessage msg = new MaidMusicToClientMessage(this.maid.getId(), info.songUrl, info.songTime, info.songName);
            MaidMusicToClientMessage.showLyric(this.maid, info.songUrl, info.songName, info.songTime);
            NetworkHandler.sendToNearby(this.maid.level(), this.maid.blockPosition(), msg);
            return true;
        }
        return false;
    }

    private boolean stopMusic() {
        long id;
        if (this.maid == null) {
            return false;
        }
        this.setSoundTicks(0);
        MaidStopMusicMessage stopMsg = new MaidStopMusicMessage(this.maid.getId());
        NetworkHandler.sendToNearby(this.maid.level(), this.maid.blockPosition(), stopMsg);
        LongOpenHashSet removeIds = new LongOpenHashSet();
        ChatBubbleDataCollection collection = this.maid.getChatBubbleManager().getChatBubbleDataCollection();
        LongBidirectionalIterator longBidirectionalIterator = collection.keySet().iterator();
        while (longBidirectionalIterator.hasNext()) {
            id = (Long)longBidirectionalIterator.next();
            IChatBubbleData data = collection.get(id);
            if (!data.id().equals((Object)LyricChatBubbleData.ID)) continue;
            removeIds.add(id);
        }
        longBidirectionalIterator = removeIds.iterator();
        while (longBidirectionalIterator.hasNext()) {
            id = (Long)longBidirectionalIterator.next();
            collection.remove(id);
        }
        this.maid.getChatBubbleManager().forceUpdateChatBubble();
        return true;
    }

    public int getSelectSlotId() {
        return this.data.get(0);
    }

    public void setSoundTicks(int ticks) {
        this.data.set(1, ticks);
    }
}

